<?php $__env->startSection('content'); ?>
    <section class="" id="pricing-soft-ui">
        <div class="bg-gradient-dark position-relative m-3 border-radius-xl">

            <div class="container pb-lg-8 pb-7 pt-5 postion-relative z-index-2 position-relative">
                <div class="row">
                    <div class="col-md-7 mx-auto text-center">
                        <span class="badge bg-gradient-primary mb-5"><?php echo e(__('Pricing and Plans')); ?></span>
                        <h3 class="text-white"><?php echo e(__('Ready to get started with focus?')); ?></h3>
                        <p class="text-white"><?php echo e(__('Choose the plan that best fit for you.')); ?></p>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <section class="">
        <div class="container">

            <div class="row">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-4">

                        <div class="row">

                            <div class="col-lg-8">
                                <div class="card-body">
                                    <h3 class="text-gradient text-info"><?php echo e($plan->name); ?></h3>
                                    <p><?php echo $plan->description; ?></p>
                                    <div class="row mt-5 mb-2">
                                        <div class="col-lg-3 col-12">
                                            <h6 class="text-dark tet-uppercase"><?php echo e(__('What is included')); ?></h6>
                                        </div>

                                    </div>
                                    <div class="row">

                                        <?php if($plan->features): ?>

                                            <?php $__currentLoopData = json_decode($plan->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <div class="col-lg-6 col-md-6 col-12 ps-0">
                                                    <div class="d-flex align-items-center p-2">
                                                        <div class="icon icon-shape icon-xs rounded-circle bg-gradient-dark opacity-6 shadow text-center">
                                                            <i class="fas fa-check opacity-10"></i>
                                                        </div>
                                                        <div>
                                                            <span class="ps-2"><?php echo e($feature); ?></span>
                                                        </div>
                                                    </div>

                                                </div>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 my-auto">
                                <div class="card-body text-center">
                                    <h6 class="mt-sm-4 mt-0 mb-0"><?php echo e(__('Monthly Price')); ?></h6>
                                    <h2 class="mt-0">
                                        <small>$</small><?php echo e($plan->price_monthly); ?>

                                    </h2>
                                    <h6 class="mt-sm-4 mt-0 mb-0">Yearly Price</h6>
                                    <h2 class="mt-0">
                                        <small>$</small><?php echo e($plan->price_yearly); ?>

                                    </h2>



                                </div>

                            </div>

                            <div class="">

                                <?php if($plan->price_monthly): ?>

                                    <a href="/subscribe?id=<?php echo e($plan->id); ?>&term=monthly" type="button" class="btn bg-gradient-dark mt-3"><?php echo e(__('Pay Monthly')); ?></a>

                                <?php endif; ?>


                                <?php if($plan->price_yearly): ?>

                                        <a href="/subscribe?id=<?php echo e($plan->id); ?>&term=yearly" type="button" class="btn bg-gradient-dark mt-3"><?php echo e(__('Pay Yearly')); ?></a>

                                    <?php endif; ?>


                            </div>



                        </div>


                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/settings/billing.blade.php ENDPATH**/ ?>