<?php $__env->startSection('content'); ?>


    <div class="page-header mb-4 border-radius-xl">
        <span class="mask bg-gradient-dark"></span>
        <div class="container">
            <div class="row">
                <p class="col-lg-6 my-auto">
                    <h5 class="text-white fadeIn2 fadeInBottom mt-4">
                    <?php echo e(__('Realise your Dreams')); ?>

                    </h5>
                    <p class="text-white opacity-8 fadeIn3 fadeInBottom">
                        <?php echo e(__('You must form a clear and definite mental picture of what you want.')); ?>


                    </p>
                <p class=" text-white opacity-8 fadeIn3 fadeInBottom">
                    <?php echo e(__('— The science of getting rich')); ?>

                </p>
                </div>
            <a  href="/set-goal" type="button" class="btn btn-outline-light">
                <?php echo e(__('Set your goals')); ?>


            </a>
            </div>


        </div>


    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header pb-0">
                    <h6><?php echo e(__('Goals')); ?></h6>
                </div>
                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                            <tr>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Name')); ?></th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                    <?php echo e(__('Estimate Date to finish')); ?>

                                </th>
                                <th class="text-center float-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                    <?php echo e(__('Completed?')); ?>


                                </th>

                                <th class="text-secondary opacity-7"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">

                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm"><?php echo e($goal->name); ?></h6>

                                            </div>
                                        </div>
                                    </td>
                                    <td>

                                        <span class="text-xs font-weight-bold"><?php echo e($goal->date); ?></span>

                                    </td>

                                    <td class="align-right text-sm">
                                        <div class="form-check float-end ">
                                            <input class="form-check-input goal_checkbox" type="checkbox"
                                                   data-id="<?php echo e($goal->id); ?>"

                                                   <?php if($goal->completed): ?> checked <?php endif; ?>

                                            >

                                        </div>
                                    </td>

                                    <td class="">
                                        <div class="ms-auto text-end">

                                            <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/goal/<?php echo e($goal->id); ?>"><i class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a>
                                            <a class="btn btn-link text-dark px-3 mb-0" href="/set-goal?id=<?php echo e($goal->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i><?php echo e(__('Edit')); ?></a>
                                        </div>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>






                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>



    </div>







<?php $__env->stopSection(); ?>




<?php $__env->startSection('script'); ?>
    <script>
        "use strict"
        $(function () {
            $('.goal_checkbox').on('change',function () {
                let that = $(this);
                if(this.checked)
                {
                    $.post('/goals/change-status',{
                        id: that.attr('data-id'),
                        status: 'Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
                else{
                    $.post('/goals/change-status',{
                        id: that.attr('data-id'),
                        status: 'Not Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus/resources/views/goals/goals.blade.php ENDPATH**/ ?>