<?php $__env->startSection('content'); ?>
    <div class="card bg-purple-light mb-3 mt-4">
        <div class="card-header bg-purple-light pb-0 p-3">
            <div class="row">
                <div class="col-md-8">
                    <h6><?php echo e(__('Users')); ?> (<?php echo e($users_count_on_this_workspace); ?>)</h6>

                    <?php if($maximum_allowed_users): ?>
                        <p><?php echo e(__('Current plan maximum allowed users:')); ?> <?php echo e($maximum_allowed_users); ?></p>
                    <?php endif; ?>
                </div>
                <div class="col-md-4 text-right">

                    <?php if($users_count_on_this_workspace < $maximum_allowed_users): ?>
                        <a class="btn bg-gradient-dark mb-0" href="/new-user"><i class="fas fa-plus"></i>&nbsp;&nbsp;
                            <?php echo e(__(' Add New User')); ?>

                        </a>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card card-body mb-4">
                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0" id="cloudonex_table">
                            <thead>
                            <tr>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Name')); ?></th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Email')); ?></th>
                                <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Phone')); ?></th>
                                <th class="text-secondary opacity-7"></th>
                            </tr>
                            <tbody>
                            <?php $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div>
                                                <?php if(empty($staff['photo'])): ?>
                                                    <div
                                                        class="avatar avatar-md bg-success-light  border-radius-md p-2 ">
                                                        <h6 class="text-success "><?php echo e($staff->first_name['0']); ?><?php echo e($staff->last_name['0']); ?></h6>
                                                    </div>
                                                <?php else: ?>

                                                    <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($staff->photo); ?>"
                                                         alt="" class="avatar avatar-md shadow-sm">
                                                <?php endif; ?>
                                            </div>
                                            <div class="d-flex flex-column justify-content-center px-3">
                                                <h6 class="mb-0 text-sm"><?php echo e($staff->first_name); ?> <?php echo e($staff->last_name); ?></h6>
                                                <p class="text-xs text-secondary mb-0"><?php echo e($staff->email); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($staff->email); ?></p>
                                    </td>
                                    <td class="align-middle text-center">
                                        <span
                                            class="text-secondary text-xs font-weight-bold"><?php echo e($staff->mobile_number); ?></span>
                                    </td>
                                    <td class="align-middle text-right">
                                        <div class="ms-auto">

                                            <?php if(!$workspace->owner_id || $staff->id != $workspace->owner_id ): ?>
                                                <a class="btn btn-link text-danger text-gradient px-3 mb-0"
                                                   href="/delete/staff/<?php echo e($staff->id); ?>"><i
                                                        class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a>
                                            <?php endif; ?>


                                            <a class="btn btn-link text-dark px-3 mb-0"
                                               href="/user-edit/<?php echo e($staff->id); ?>"><i
                                                    class="fas fa-pencil-alt text-dark me-2"
                                                    aria-hidden="true"></i><?php echo e(__('Edit')); ?></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $('#cloudonex_table').DataTable(
            );

        });
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/profile/staff.blade.php ENDPATH**/ ?>