<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-5">
            <div class="card">
                <div class="card-header pb-0 p-3">
                </div>
                <div class="card-body p-3">
                    <div class="row gx-4">
                        <div class="col-auto">
                            <div class="avatar avatar-xxl position-relative">
                                <?php if(empty($skit_user['photo'])): ?>
                                    <img src="<?php echo e(PUBLIC_DIR); ?>/img/user-avatar-placeholder.png"
                                         class="w-100 border-radius-lg shadow-sm">
                                <?php else: ?>

                                    <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($skit_user->photo); ?>" alt=""
                                         class="w-100 border-radius-lg shadow-sm">
                                <?php endif; ?>

                            </div>
                        </div>
                        <div class="col-auto my-auto">
                            <div class="h-100">
                                <h5 class="mb-1">
                                    <?php echo e($skit_user->first_name); ?> <?php echo e($skit_user->last_name); ?>


                                </h5>
                                <p class="mb-0 font-weight-bold text-sm">
                                    <?php echo e($skit_user->email); ?>

                                </p>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 my-sm-auto ms-sm-auto me-sm-0 mx-auto mt-3">
                            <div class="nav-wrapper position-relative end-0">
                                <ul class="nav nav-pills nav-fill p-1 bg-transparent" role="tablist">
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4 mb-4 ">
                        <div class="col-md-8 d-flex align-items-center">
                            <h6 class="mb-0 text-muted"><?php echo e(__('Details')); ?></h6>
                        </div>
                    </div>
                    <ul class="list-group">
                        <li class="list-group-item border-0 ps-0 pt-0 text-sm"><strong
                                class="text-dark"><?php echo e(__('Full Name:')); ?></strong> <?php echo e($skit_user->first_name); ?> <?php echo e($skit_user->last_name); ?>

                        </li>
                        <li class="list-group-item border-0 ps-0 text-sm"><strong
                                class="text-dark"><?php echo e(__('Mobile Number:')); ?></strong> <?php echo e($skit_user->mobile_number); ?></li>
                        <li class="list-group-item border-0 ps-0 text-sm"><strong
                                class="text-dark"><?php echo e(__('Email:')); ?></strong> <?php echo e($skit_user->email); ?></li>
                        <li class="list-group-item border-0 ps-0 text-sm"><strong
                                class="text-dark"><?php echo e(__('Account Created:')); ?></strong>
                            <?php echo e((\App\Supports\DateSupport::parse($skit_user->created_at))->format(config('app.date_time_format'))); ?>

                            </li>

                    </ul>

                    <a class="btn btn-info mb-3 mt-3" href="/user-edit/<?php echo e($skit_user->id); ?>"><?php echo e(__('Edit')); ?></a>

                </div>

            </div>
        </div>
        <div class="col-md-7">
            <?php if($skit_user_workspace->subscribed): ?>

                <div class="card">
                    <div class="card-body">
                        <h6 class="mb-0 fw-bolder"><?php echo e(__('Billing information')); ?></h6>
                        <?php if($plan): ?>

                            <p class="mt-4"><strong><?php echo e(__('Subscribed Plan')); ?>:</strong> <?php echo e($plan->name); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($skit_user_workspace->next_renewal_date)): ?>
                            <p><strong><?php echo e(__('Next renewal date')); ?>:</strong> <?php echo e(date('M d Y',strtotime($workspace->next_renewal_date))); ?></p>
                        <?php endif; ?>
                    </div>
                </div>

            <?php endif; ?>

        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/super-admin/user-profile.blade.php ENDPATH**/ ?>