<?php $__env->startSection('content'); ?>
    <div class="row mt-1 d-print-none">
        <div class="col">
            <h5 class="text-secondary fw-bolder">
                <?php echo e(__('Business Plan')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a href="#" onclick="window.print()"
               class="btn bg-gradient-dark btn-sm add_event waves-effect waves-light"><?php echo e(__('Print')); ?></a>
            <a href="/write-business-plan?id=<?php echo e($plan->id); ?>"
               class="btn btn-sm btn-warning add_event waves-effect waves-light"><?php echo e(__('Edit')); ?></a>
            <a href="/delete/business-plan/<?php echo e($plan->id); ?>"
               class="btn btn-sm btn-danger add_event waves-effect waves-light"><?php echo e(__('Delete')); ?></a>
        </div>

    </div>

    <div class="">
        <div class="col-lg-12">
            <div class="card-body ">
                <div class="page-header mb-4">
                    <span class="mask bg-purple-light"></span>
                    <div class="container">
                        <div class="row">

                            <div class="col-md-12 mt-3 mb-2">

                                <h5 class="text-dark">
                                    <?php if(!empty($plan->logo)): ?>
                                        <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($plan->logo); ?>" class="w-5">
                                    <?php endif; ?>
                                    <?php echo e($plan->company_name); ?>

                                </h5>

                                <h4 class="text-purple  fw-bolder fadeIn2 fadeInBottom mt-4 mb-2"><?php echo e(__('Business Plan')); ?></h4>
                                <h6 class="text-muted fadeIn2 fadeInBottom">
                                    <?php if(!empty($plan->date)): ?>
                                        <?php echo e((\App\Supports\DateSupport::parse($plan->date))->format(config('app.date_format'))); ?>


                                    <?php endif; ?>
                                </h6>
                            </div>
                            <div class="mb-3">
                                <h6 class="text-secondary"><?php echo e(__('Written By')); ?></h6>
                                <h6><?php echo e($plan->name); ?></h6>
                                <h6 class="text-muted"><?php echo e($plan->email); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($plan->ex_summary): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Executive Summary')); ?></h6>
                    </div>
                    <div>
                        <?php echo $plan->ex_summary; ?>

                    </div>
                <?php endif; ?>
                <?php if($plan->description): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Company description')); ?></h6>
                    </div>
                    <?php echo $plan->description; ?>

                <?php endif; ?>
                <?php if($plan->m_analysis): ?>

                    <div class="mt-4">
                        <h6><?php echo e(__('Market Analysis')); ?></h6>
                    </div>
                    <?php echo $plan->m_analysis; ?>


                <?php endif; ?>


                <?php if($plan->management): ?>

                    <div class="mt-4">
                        <h6><?php echo e(__('Organization & Management')); ?></h6>
                    </div>
                    <?php echo $plan->management; ?>


                <?php endif; ?>

                <?php if($plan->product): ?>

                    <div class="mt-4">
                        <h6><?php echo e(__('Service or product')); ?></h6>
                    </div>
                    <?php echo $plan->product; ?>


                <?php endif; ?>

                <?php if($plan->marketing): ?>

                    <div class="mt-4">
                        <h6><?php echo e(__('Marketing and sales')); ?></h6>
                    </div>
                    <?php echo $plan->marketing; ?>


                <?php endif; ?>

                <?php if($plan->budget): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Budget')); ?></h6>
                    </div>
                    <?php echo $plan->budget; ?>

                <?php endif; ?>

                <?php if( $plan->investment ): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Investment/Funding request')); ?></h6>
                    </div>
                    <?php echo $plan->investment; ?>

                <?php endif; ?>

                <?php if($plan->finance): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Financial projections')); ?></h6>
                    </div>
                    <?php echo $plan->finance; ?>

                <?php endif; ?>

                <?php if($plan->appendix): ?>
                    <div class="mt-4">
                        <h6><?php echo e(__('Appendix')); ?></h6>
                    </div>
                    <?php echo $plan->appendix; ?>

                <?php endif; ?>

                <?php if(!empty($plan->file)): ?>
                    <div class="">
                        <!-- Buttons -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                             stroke-linejoin="round" class="feather feather-file-text">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                            <line x1="16" y1="13" x2="8" y2="13"></line>
                            <line x1="16" y1="17" x2="8" y2="17"></line>
                            <polyline points="10 9 9 9 8 9"></polyline>
                        </svg>
                        <a href="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($plan->file); ?>" class="fw-bolder">
                            <?php echo e($plan->file); ?>

                        </a>

                    </div>

                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/plans/view-business-plan.blade.php ENDPATH**/ ?>