<?php $__env->startSection('content'); ?>


    <div class="card mb-3 mt-4">
        <div class="card-header pb-0 p-3">
            <div class="row">
                <div class="col-md-6 d-flex align-items-center">
                    <div class="col-md-6 text-left">
                        <a class="btn bg-gradient-dark mb-2" href="/people">&nbsp;&nbsp;people</a>
                        <a class="btn bg-gradient-dark mb-2" href="/audiences">&nbsp;&nbsp;Audiences</a>
                    </div>

                </div>
                <div class="col-md-6 text-right">
                    <button type="button" class="btn bg-gradient-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        Add Audience
                    </button>
                </div>
            </div>
        </div>
        <div class="card-body  p-3">

        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card mb-4">


                <div class="card-body px-0 pt-0 pb-2">
                    <div class="table-responsive p-0">
                        <table class="table align-items-center mb-0">
                            <thead>
                            <tr>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Name</th>


                                <th class="text-secondary opacity-7"></th>
                            </tr>


                            <tbody>
                            <?php $__currentLoopData = $audiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $audience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">

                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm"><?php echo e($audience->name); ?></h6>

                                            </div>
                                        </div>
                                    </td>

                                    <td class="text-right">

                                        <button type="button" class="btn btn-sm bg-gradient-default">Import</button>

                                        <button type="button" class="btn btn-sm bg-gradient-secondary">Edit</button>
                                        <a  href="/delete/audience/<?php echo e($audience->id); ?>" type="button" class="btn btn-sm bg-gradient-primary">Delete</a>








                                    </td>
                                </tr>


                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Audience</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="card-body  p-3">
                        <form method="post" id="form_main">

                            <div id="sp_result_div"></div>

                            <div class="form-group">
                                <label for="example-email-input" class="form-control-label">Name</label>
                                <input class="form-control" name="name" type="text"  id="name">
                            </div>

                                <?php echo csrf_field(); ?>
                                <div class="text-right">
                                    <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" id="btn_submit" class="btn bg-gradient-primary">Save</button>

                                </div>


                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>
        $(function () {

            let $btn_submit = $('#btn_submit');
            let $form_main = $('#form_main');
            let $sp_result_div = $('#sp_result_div');

            $form_main.on('submit',function (event) {
                event.preventDefault();
                $btn_submit.prop('disabled',true);
                $.post('/audience',$form_main.serialize()).done(function () {
                    location.reload();
                }).fail(function (data) {
                    let obj = $.parseJSON(data.responseText);
                    $btn_submit.prop('disabled',false);
                    let html = '';
                    $.each(obj.errors, function(key,value) {
                        html += '<div class="alert alert-danger">'+ value +'</div>'
                    });

                    $sp_result_div.html(html);

                });

            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/contacts/audiences.blade.php ENDPATH**/ ?>