<?php $__env->startSection('content'); ?>

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-lg-9 col-12 mx-auto">
                <div class="card card-body">
                    <h6 class="mb-0"><?php echo e(__('New Plan')); ?></h6>
                    <p class="text-sm mb-0"><?php echo e(__('Create new plan')); ?></p>
                    <form action="/save-subscription-plan" method="post">
                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <hr class="horizontal dark my-3">



                        <div class="mb-3">
                            <label for="projectName" class="form-label"><?php echo e(__('Plan Name')); ?></label><label class="text-danger">*</label>
                            <input type="text" class="form-control" name="name" value="<?php echo e($plan->name ?? old('name') ?? ''); ?>" id="projectName">
                        </div>

                            <div class="mb-3">
                                <label for="projectName" class="form-label mt-3"><?php echo e(__('Maximum Allowed Users')); ?></label><label class="text-danger">*</label>
                                <input type="number" class="form-control" name="maximum_allowed_users" value="<?php echo e($plan->maximum_allowed_users ?? old('maximum_allowed_users') ?? ''); ?>" id="projectName">
                            </div>


                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="max_file_upload_size" class="form-label"><?php echo e(__('Maximum File Upload Size')); ?>  (<?php echo e(__('kb')); ?>)</label><label class="text-danger">*</label>
                                        <input type="text" class="form-control" name="max_file_upload_size" value="<?php echo e($plan->max_file_upload_size ?? old('max_file_upload_size') ?? ''); ?>" id="max_file_upload_size">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="file_space_limit" class="form-label"><?php echo e(__('File Space Limit')); ?> (<?php echo e(__('mb')); ?>)</label><label class="text-danger">*</label>
                                        <input type="text" class="form-control" name="file_space_limit" value="<?php echo e($plan->file_space_limit ?? old('file_space_limit') ?? ''); ?>" id="file_space_limit">

                                    </div>
                                </div>
                            </div>




                        <div class="row mt-4">
                            <label>
                                <?php echo e(__('Pricing')); ?>

                            </label>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Monthly')); ?></label><label class="text-danger">*</label>
                                <input class="form-control datetimepicker" type="text" name="price_monthly" value="<?php echo e($plan->price_monthly ?? old('price_monthly') ?? ''); ?>" data-input>
                            </div>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Yearly')); ?></label><label class="text-danger">*</label>
                                <input class="form-control datetimepicker" name="price_yearly" type="text"
                                       value="<?php echo e($plan->price_yearly ?? old('price_yearly') ?? ''); ?>" data-input>
                            </div>
                        </div>

                            <div class="mb-3 mt-3">
                                <label for="paypal_plan_id" class="form-label"><?php echo e(__('PayPal Plan ID')); ?></label>
                                <input type="text" class="form-control" name="paypal_plan_id" value="<?php echo e($plan->paypal_plan_id ?? old('name') ?? ''); ?>" id="paypal_plan_id">
                            </div>

                        <label
                            class="text-uppercase text-body text-xs font-weight-bolder mt-4"><?php echo e(__('Modules')); ?></label>
                        <ul class="list-group">
                            <?php $__currentLoopData = $available_modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item border-0 px-0">
                                    <div class="form-check form-switch ps-0">
                                        <input class="form-check-input ms-auto" type="checkbox" id="module_<?php echo e($key); ?>"
                                               name="<?php echo e($key); ?>" value="1"
                                               <?php if(!empty($plan_modules) && in_array($key,$plan_modules)): ?> checked <?php endif; ?>>
                                        <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0"
                                               for="module_<?php echo e($key); ?>"><?php echo e($value); ?></label>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                        <label class="mt-4"><?php echo e(__('Description')); ?></label>

                        <div class="form-group">
                            <textarea class="form-control" rows="10" id="description"
                                      name="description"><?php if(!empty($plan)): ?><?php echo e($plan->description); ?><?php endif; ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Features')); ?></label>
                            <div id="div_features">

                                <?php if(!empty($features)): ?>
                                    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="row feature_row">
                                            <div class="col-md-9">
                                                <input type="text" class="form-control" name="features[]" value="<?php echo $feature; ?>">
                                            </div>
                                            <div class="col-md-3 text-end">
                                                <button class="btn btn-sm btn-danger btn_remove_feature"><i class="fas fa-minus"></i> </button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <div class="row feature_row">
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" name="features[]">
                                    </div>
                                    <div class="col-md-3 text-end">
                                        <button class="btn btn-sm btn-danger btn_remove_feature"><i class="fas fa-minus"></i> </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <button class="btn btn-sm btn-dark" id="btn_add_feature"><i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <?php echo csrf_field(); ?>
                        <?php if($plan): ?>
                            <input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
                        <?php endif; ?>
                        <div class="d-flex  mt-4">

                            <button type="submit" name="button"
                                    class="btn btn-info m-0 "><?php echo e(__('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            "use strict";
            flatpickr("#start_date", {

                dateFormat: "Y-m-d",
            });

            flatpickr("#end_date", {

                dateFormat: "Y-m-d",
            });

            tinymce.init({
                selector: '#description',


                plugins: 'table,code',


            });

            let $btn_add_feature = $('#btn_add_feature');
            let $div_features = $('#div_features');

            $btn_add_feature.on('click', function (event) {
                event.preventDefault();
                $div_features.append('<div class="row feature_row"><div class="col-md-9"><input type="text" class="form-control" name="features[]"></div><div class="col-md-3 text-end"><button class="btn btn-sm btn-danger btn_remove_feature"><i class="fas fa-minus"></i> </button></div></div>');

            });

            let $clx_body = $('#clx_body');

            $clx_body.on('click', '.btn_remove_feature', function (event) {
                event.preventDefault();
                $(this).closest('.feature_row').remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/super-admin/create-plan.blade.php ENDPATH**/ ?>