<?php $__env->startSection('title',__('Blogs')); ?>
<?php $__env->startSection('content'); ?>

    <div class=" row mb-2">
        <div class="col">
            <h5 class=" fw-bolder">
                <?php echo e(__('Blogs')); ?> /<span class="text-secondary">
                            <?php echo e(__('Article List')); ?>

                    </span>
            </h5>
            <p class="text-muted"><?php echo e(__('Create, edit or delete blog articles.')); ?></p>
        </div>
        <div class="col text-end">
            <a href="/write-blog" type="button" class="btn btn-info"><i class="fas fa-plus"></i> <?php echo e(__('Write New Blog')); ?></a>

        </div>
    </div>

    <?php if(!count($blogs)): ?>

        <div class="card">
            <div class="card-body">
                <p><?php echo e(__('No items to display. Get started by writing an article.')); ?></p>

                <a href="/write-blog" type="button" class="btn btn-info text-white"><i class="fas fa-plus"></i> <?php echo e(__('Write an article ')); ?></a>
            </div>
        </div>

    <?php else: ?>

    <div class="row" data-masonry='{"percentPosition": true }'>
        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-4">
                <div class="card">
                    <?php if(!empty($blog->cover_photo)): ?>
                        <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($blog->cover_photo); ?>" class="card-img-top">
                    <?php endif; ?>

                    <div class="card-body ">
                        <p class="mb-1 pt-2 text-bold"><?php echo e($blog->topic); ?></p>
                        <h5 class="card-title"><?php echo e($blog->title); ?></h5>

                        <div class="mt-3">
                            <a href="/view-blog?id=<?php echo e($blog->id); ?>" class="btn btn-success btn-xs mb-0"><?php echo e(__('Read')); ?></a>

                            <a href="/write-blog?id=<?php echo e($blog->id); ?>" class="btn btn-info btn-xs mb-0"><?php echo e(__('Edit')); ?></a>
                            <a href="/delete/blog/<?php echo e($blog->id); ?>" class="btn btn-warning btn-xs mb-0"><?php echo e(__('Delete')); ?></a>
                        </div>


                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/blog/blogs.blade.php ENDPATH**/ ?>