<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header fw-bolder">
           <h4> <?php echo e(__('Configure payment gateway')); ?></h4>
        </div>

        <div class="card-body pt-0">

            <form action="/configure-gateway" method="post">

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php switch($api_name):

                    case ('paypal'): ?>

                    <h5 class="mb-3"><?php echo e(__('PayPal')); ?></h5>

                    <div class="mb-3">
                        <label for="Paypal Client ID"><?php echo e(__('Paypal Client ID')); ?></label>
                        <input name="username" class="form-control"
                        value="<?php echo e($gateway->username ?? ''); ?>"
                        >
                        <input type="hidden" name="api_name" value="paypal">

                    </div>

                        <div class="mb-3">
                            <label for="Paypal Password"><?php echo e(__('Paypal Client Secret')); ?></label>
                            <input type="password" name="password" class="form-control"
                            value="<?php echo e($gateway->password ?? ''); ?>"
                            >
                        </div>

                    <?php break; ?>


                    <?php case ('stripe'): ?>

                    <h5 class="mb-3"><?php echo e(__('Stripe')); ?></h5>

                    <div class="form-group">
                        <label for="Public Key"><?php echo e(__('Public Key')); ?></label>
                        <input type="text" name="public_key" <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->public_key); ?>"<?php endif; ?> class="form-control" id="public_key">
                    </div>

                    <div class="form-group">
                        <label for="Private Key"><?php echo e(__('Private Key')); ?></label>
                        <input type="text" name="private_key"
                               <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->private_key); ?>" <?php endif; ?> class="form-control" id="private-key">
                    </div>
                        <input type="hidden" name="api_name" value="stripe">

                    <?php break; ?>

                        <?php case ('bank'): ?>

                        <h5 class="mb-3"><?php echo e(__('Bank')); ?></h5>

                        <div class="form-group">
                            <label><?php echo e(__('Bank Name')); ?></label>
                            <input type="text" name="name" <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->name); ?>" <?php endif; ?> class="form-control" id="name">
                        </div>

                        <div class="form-group">
                            <label><?php echo e(__('Payment Instruction')); ?></label>
                            <textarea type="text" name="instruction"  class="form-control" id="private-key"><?php if(!empty($gateway)): ?><?php echo e($gateway->instruction); ?><?php endif; ?></textarea>
                        </div>
                        <input type="hidden" name="api_name" value="bank">

                        <?php break; ?>

                        <?php case ('paystack'): ?>
                        <h5 class="mb-3"><?php echo e(__('Paystack')); ?></h5>
                        <div class="form-group">
                            <label for="Public Key"><?php echo e(__('Paystack Public Key')); ?></label>
                            <input type="text" name="public_key" value="<?php echo e($gateway->public_key ?? ''); ?>" class="form-control" id="public_key">
                            <input type="hidden" name="api_name" value="stripe">
                        </div>

                        <div class="form-group">
                            <label for="Private Key"><?php echo e(__('Paystack Secret Key')); ?></label>
                            <input type="text" name="private_key" <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->private_key); ?>" <?php endif; ?> class="form-control" id="private-key">
                            <input type="hidden" name="api_name" value="paystack">
                        </div>

                        <?php break; ?>
                    <?php endswitch; ?>
                <?php echo csrf_field(); ?>

                <?php if($gateway): ?>
                    <input type="hidden" name="id" value="<?php echo e($gateway->id); ?>">
                <?php endif; ?>


                <button type="submit" class="btn btn-success"><?php echo e(__('Save')); ?></button>


            </form>

        </div>





    </div>



<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/super-admin/configure-payment-gateway.blade.php ENDPATH**/ ?>