<?php $__env->startSection('content'); ?>

    <div class="row mb-4">

        <div class="mt-lg-0 ">

            <div class="card " id="basic-info">
                <div class="card-header">

                    <div class="float-end">
                        <a  href="/projects" type="button" class="btn btn-sm bg-gradient-dark">
                            <?php echo e(__('Project List')); ?>

                        </a>
                        <a href="/create-project?id=<?php echo e($project->id); ?>" type="button" class="btn btn-sm bg-gradient-secondary"><?php echo e(__('Edit')); ?></a>

                    </div>
                    <span><h5 class=""><?php echo e($project->title); ?></h5><span class="badge bg-gradient-info  font-weight-bold"><?php echo e($project->status); ?></span></span>



                </div>
                <div class=" ms-4">
                    <div class="pt-0">
                        <div class="row">
                            <div class="col-md-2">
                                <span>
                                    <div class="ms-auto">
                            <span class="badge badge-sm bg-gradient-faded-light text-dark fw-bolder mb-1">

                                <?php if(!empty($project->start_date)): ?>
                                    <?php echo e($project->start_date->format(config('app.date_format'))); ?>

                                <?php endif; ?>



                            </span>
                                        <p class="text-sm fw-bolder text-black-50"><?php echo e(__('Start date')); ?></p>
                        </div>
                                </span>
                            </div>
                            <div class="col-md-2">

                                <span>

                                    <div class="ms-auto">
                            <span class="badge badge-sm bg-gradient-faded-light text-dark fw-bolder mb-1">

                              <?php if(!empty($project->end_date)): ?>
                                    <?php echo e($project->end_date->format(config('app.date_format'))); ?>

                                <?php endif; ?>



                            </span>
                                                <p class="text-sm fw-bolder text-black-50"><?php echo e(__('Due date')); ?></p>
                        </div>
                                </span>
                            </div>

                            <div class="col-md-6">
                                <div class="d-flex">

                                    <?php if($project->members): ?>
                                        <?php $__currentLoopData = json_decode($project->members); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($users[$member])): ?>

                                                <div class="col-md-2 text-center">


                                                    <?php if(!empty($users[$member]->photo)): ?>
                                                        <a href="javascript:;" class="avatar avatar-md rounded-circle border border-secondary">
                                                            <img alt="" class="p-1" src="<?php echo e(PUBLIC_DIR); ?>/storage/<?php echo e($users[$member]->photo); ?>">
                                                        </a>
                                                    <?php else: ?>
                                                        <div class="avatar avatar-md rounded-circle bg-purple-light  border-radius-md p-2">
                                                            <h6 class="text-purple mt-1"><?php echo e($users[$member]->first_name[0]); ?><?php echo e($users[$member]->last_name[0]); ?></h6>
                                                        </div>


                                                    <?php endif; ?>

                                                    <p class="mb-0 text-sm"><?php echo e($users[$member]->first_name); ?></p>


                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    <?php endif; ?>
                                    <div class="col-md-2 text-center">
                                        <a href="/create-project?id=<?php echo e($project->id); ?>" class="avatar avatar-md border-1 rounded-circle bg-gradient-light">
                                            <i class="fas fa-plus text-white"></i>
                                        </a>

                                    </div>


                                </div>

                            </div>



                        </div>



                    </div>

                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="col-lg-7 col-md-12 my-sm-auto ms-sm-auto me-sm-0 mx-auto ">
                            <div class="nav-wrapper position-relative end-0">
                                <ul class="nav nav-pills nav-fill p-1 bg-transparent" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link mb-0 px-0 py-1 active " data-bs-toggle="" href="/view-project?id=<?php echo e($project->id); ?>" role="button" aria-selected="true">

                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><polyline points="10 9 9 9 8 9"></polyline></svg>
                                            <span class="ms-1">Overview</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link mb-0 px-0 py-1  active " data-bs-toggle="" href="/view-project-discussion?id=<?php echo e($project->id); ?>" role="button" aria-selected="false">


                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-square"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                            <span class="ms-1">Discussions</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link mb-0 px-0 py-1 " data-bs-toggle="" href="/view-project-files?id=<?php echo e($project->id); ?>" role="button" aria-selected="false">

                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-paperclip"><path d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48"></path></svg>
                                            <span class="ms-1">Files</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link mb-0 px-0 py-1 " data-bs-toggle="" href="/view-project-tasks?id=<?php echo e($project->id); ?>" role="button" aria-selected="false">


                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-list"><line x1="8" y1="6" x2="21" y2="6"></line><line x1="8" y1="12" x2="21" y2="12"></line><line x1="8" y1="18" x2="21" y2="18"></line><line x1="3" y1="6" x2="3.01" y2="6"></line><line x1="3" y1="12" x2="3.01" y2="12"></line><line x1="3" y1="18" x2="3.01" y2="18"></line></svg>
                                            <span class="ms-1">Tasks</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>



                    </div>
                </div>



            </div>




        </div>
    </div>


    <div class="col-md-12">
        <div class="card" id="additional_settings">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="mb-0"><?php echo e(__('Project Tasks')); ?></h6>

                    </div>



                    <div class="col-md-6 d-flex justify-content-end ">
                        <a  href="/add-task?for=project" type="button" class="btn btn-sm bg-gradient-dark"><?php echo e(__('Add To-dos')); ?></a>

                    </div>

                </div>
                <hr class="horizontal dark mb-0">
            </div>
            <div class="card-body p-3 pt-0">
                <ul class="list-group list-group-flush" data-toggle="checklist">
                    <?php $__currentLoopData = $todos_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                        <li class="list-group-item border-0 flex-column align-items-start ps-0 py-0 mb-3">
                            <div class="checklist-item checklist-item-primary ps-2 ms-3">
                                <div class="d-flex align-items-center">
                                    <div class="form-check">
                                        <input class="form-check-input todo_checkbox" type="checkbox"
                                               data-id="<?php echo e($todo->id); ?>"

                                               <?php if($todo->completed): ?> checked <?php endif; ?>

                                        >
                                    </div>
                                    <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>  <div class="float-end">

                                        <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/today-todo/<?php echo e($todo->id); ?>"><i class="far fa-trash-alt me-2"></i></a>
                                        <a class="btn btn-link text-dark px-3 mb-0" href="/add-task/?id=<?php echo e($todo->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i></a>
                                        </a>

                                    </div>

                                </div>
                                <div class="d-flex align-items-center ms-4 mt-3 ps-1">
                                    <div>
                                        <p class="text-xs mb-0 text-secondary font-weight-bold"><?php echo e(__('Date')); ?></p>
                                        <span class="text-xs font-weight-bolder"><?php echo e($todo->date); ?></span>
                                    </div>

                                </div>
                            </div>

                            <hr class="horizontal dark mt-4 mb-0">
                        </li>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                </ul>
            </div>
        </div>
    </div>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>


    <script>
        "use strict"
        $(function () {
            $('.todo_checkbox').on('change',function () {
                let that = $(this);
                if(this.checked)
                {
                    $.post('/todos/change-status',{
                        id: that.attr('data-id'),
                        status: 'Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
                else{
                    $.post('/todos/change-status',{
                        id: that.attr('data-id'),
                        status: 'Not Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/projects/project-task.blade.php ENDPATH**/ ?>