<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <div class="row">
            <form action="/save-project" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="col-lg-9 col-12 mx-auto">
                    <div class="card card-body mt-4">
                        <h6 class="mb-0">New Project</h6>
                        <p class="text-sm mb-0">Create new project</p>
                        <hr class="horizontal dark my-3">


                        <label for="projectName" class="form-label">Project Name</label>
                        <input type="text"<?php if(!empty($project)): ?> value="<?php echo e($project->title); ?>"<?php endif; ?>   name="title" class="form-control" id="projectName">

                        <label class="mt-4 text-sm mb-0">Project Summary</label>
                        <p class="form-text text-muted text-xs ms-1">
                            Write a short summary of the project.Within 225 words
                        </p>

                        <div class="form-group">


                            <textarea name="summary" class="form-control" rows="4" id="editor" name="budget"><?php if(!empty($project)): ?><?php echo e($project->summary); ?><?php endif; ?></textarea>
                        </div>


                        <div class="row mt-4">
                            <div class="col-6">
                                <label class="form-label">Start Date</label>
                                <input class="form-control datetimepicker" name="start_date" type="date" id="start_date" placeholder="Please select start date"  <?php if(!empty($project)): ?>
                                value="<?php echo e($project->start_date); ?>"
                                       <?php else: ?>
                                       value="<?php echo e(date('Y-m-d')); ?>"
                                    <?php endif; ?>>
                            </div>
                            <div class="col-6">
                                <label class="form-label">End Date</label>
                                <input class="form-control datetimepicker" name="end_date" type="date" id="end_date"  placeholder="Please select end date" <?php if(!empty($project)): ?>
                                value="<?php echo e($project->end_date); ?>"
                                       <?php else: ?>
                                       value="<?php echo e(date('Y-m-d')); ?>"
                                <?php endif; ?>>
                            </div>
                        </div>




                        <label class="mt-4 text-sm mb-0">Project Description</label>
                        <p class="form-text text-muted text-xs ms-1">
                            Write a well organised description of the project.
                        </p>

                        <div class="form-group">
                            <textarea class="form-control" rows="10" id="description" name="description"><?php if(!empty($project)): ?><?php echo e($project->description); ?><?php endif; ?>
                            </textarea>
                        </div>
                    <?php echo csrf_field(); ?>
                        <?php if($project): ?>
                            <input type="hidden" name="id" value="<?php echo e($project->id); ?>">
                        <?php endif; ?>

                        <div class="d-flex justify-content-end mt-4">
                            <button type="button" name="button" class="btn btn-light m-0">Cancel</button>
                            <button type="submit" name="button" class="btn bg-gradient-primary m-0 ms-2">Create Project</button>
                        </div>
                    </div>
                </div>

            </form>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>
        $(function () {


            flatpickr("#start_date", {

                dateFormat: "Y-m-d",
            });

            flatpickr("#end_date", {

                dateFormat: "Y-m-d",
            });


            tinymce.init({
                selector: '#description',


                plugins: 'table,code,advlist',


            });

        });


    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/projects/create-project.blade.php ENDPATH**/ ?>