<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="font-weight-bolder"><?php echo e(__('New Report')); ?></h4>
                    <hr>
                    <form method="post" action="/save-report">
                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="example-search-input" class="form-control-label"><?php echo e(__('Produced by')); ?></label><label class="text-danger">*</label>
                                        <input class="form-control" name="name" type="text"
                                               value="<?php echo e($model->name ?? old('name') ?? ''); ?>">
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="example-search-input" class="form-control-label"><?php echo e(__('Date of elaboration')); ?></label>
                                        <input class="form-control" name="date" id="date" <?php if(!empty($model->date)): ?>
                                        value="<?php echo e($model->date); ?>"
                                               <?php else: ?>
                                               value="<?php echo e(date('Y-m-d')); ?>"
                                            <?php endif; ?> >
                                    </div>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Select Product')); ?></label>
                                    <select class="form-select form-select-solid fw-bolder" id="contact"
                                            aria-label="Floating label select example" name="product_id">
                                        <option value="0"><?php echo e(__('None')); ?></option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>"
                                                    <?php if(!empty($model)): ?>
                                                    <?php if($model->product_id === $product->id): ?>
                                                    selected
                                                <?php endif; ?>
                                                <?php endif; ?>
                                            ><?php echo e($product->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="example-text-input" class="form-control-label">
                                            <?php echo e(__('Status')); ?>

                                        </label><span class="text-danger">*</span>
                                        <select class="form-select" aria-label="Default select example" name="status">
                                            <option value="Formulation"
                                                    <?php if(($model->status ?? null) === 'Formulation'): ?> selected <?php endif; ?>><?php echo e(__('Formulation')); ?></option>
                                            <option value="Execution"
                                                    <?php if(($model->status ?? null) === 'Execution'): ?> selected <?php endif; ?>><?php echo e(__('Execution')); ?></option>
                                            <option value="Validation"
                                                    <?php if(($model->status ?? null) === 'Validation'): ?> selected <?php endif; ?>>
                                                Validation
                                            </option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                        <div class="row mt-4">
                            <div class="col align-self-end">
                                <div class="col align-self-center">
                                    <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Executive summary ')); ?>

                                        </label>

                                        <textarea class="form-control mt-4" rows="10" id="structure"
                                                  name="executive_summary"><?php if(!empty($model)): ?><?php echo e($model->executive_summary); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Administrative analysis')); ?>

                                    </label>

                                    <textarea class="form-control mt-4" rows="10" id="strategy" name="administrative_analysis"><?php if(!empty($model)): ?><?php echo e($model->administrative_analysis); ?><?php endif; ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col align-self-end">
                                <div class="col align-self-center">
                                    <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Technical analysis')); ?>

                                        </label>

                                        <textarea class="form-control mt-4" rows="10" id="system"
                                                  name="technical_analysis"><?php if(!empty($model)): ?><?php echo e($model->technical_analysis); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Financial analysis')); ?>

                                    </label>

                                    <textarea class="form-control mt-4" rows="10" id="style"
                                              name="financial_analysis"><?php if(!empty($model)): ?><?php echo e($model->financial_analysis); ?><?php endif; ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">

                            <div class="col-md-6 align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Improvement activities')); ?>

                                    </label>

                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="shared"
                                              name="improvement_activities"><?php if(!empty($model)): ?><?php echo e($model->improvement_activities); ?><?php endif; ?></textarea>
                                </div>
                            </div>
                            <div class="col-md-6 align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Observations and recommendations')); ?>

                                    </label>
                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="observations"
                                              name="recommendations"><?php if(!empty($model)): ?><?php echo e($model->recommendations); ?><?php endif; ?></textarea>
                                </div>
                            </div>

                        </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="example-text-input" class="form-control-label">
                                            <?php echo e(__('Uncertainty level')); ?>

                                        </label><span class="text-danger">*</span>
                                        <select class="form-select" aria-label="Default select example" name="uncertainty_level">
                                            <option value="High"
                                                    <?php if(($model->uncertainty_level ?? null) === 'High'): ?> selected <?php endif; ?>><?php echo e(__('High')); ?></option>
                                            <option value="Tolerable"
                                                    <?php if(($model->uncertainty_level ?? null) === 'Tolerable'): ?> selected <?php endif; ?>><?php echo e(__('Tolerable')); ?></option>
                                            <option value="Low" <?php if(($model->uncertainty_level ?? null) === 'Low'): ?> selected <?php endif; ?>><?php echo e(__('Low')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="example-text-input" class="form-control-label">
                                            <?php echo e(__('Feasibility level')); ?>

                                        </label><span class="text-danger">*</span>
                                        <select class="form-select" aria-label="Default select example" name="feasibility_level">
                                            <option value="Investment ready"
                                                    <?php if(($model->feasibility_level ?? null) === 'Investment ready'): ?> selected <?php endif; ?>><?php echo e(__(' Investment ready')); ?></option>
                                            <option value="Feasible for validation"
                                                    <?php if(($model->feasibility_level ?? null) === 'Feasible for validation'): ?> selected <?php endif; ?>><?php echo e(__(' Feasible for validation')); ?></option>
                                            <option value="Little feasible" <?php if(($model->feasibility_level ?? null) === 'Little feasible'): ?> selected <?php endif; ?>><?php echo e(__('Little feasible')); ?></option>
                                        </select>
                                    </div>

                                </div>
                            </div>

                        <?php if($model): ?>
                            <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                        <?php endif; ?>
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-info mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>

        $(function () {
            "use strict";

            flatpickr("#date", {

                dateFormat: "Y-m-d",
            });

        });

    </script>
    <script>

        (function(){
            "use strict";
            tinymce.init({
                selector: '#structure',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#strategy',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#system',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#skill',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#staff',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#style',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#observations',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#shared',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
        })();
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/reports/new.blade.php ENDPATH**/ ?>