<?php $__env->startSection('content'); ?>

    <div class="container-fluid py-4">
        <div class="row">
            <form action="/save-notice" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="col-lg-9 col-12 mx-auto">
                    <h4 class="mb-0"><?php echo e(__('Write Notice')); ?></h4>
                    <p> <?php echo e(__('NB: Only the latest published notice will be visible on the user dashboard')); ?></p>
                    <div class="card card-body mt-4">



                        <label for="projectName" class="form-label"><?php echo e(__('Title')); ?></label>
                        <input type="text" <?php if(!empty($notice)): ?> value="<?php echo e($notice->title); ?>" <?php endif; ?>   name="title" class="form-control" id="projectName">

                        <div class="mt-3">
                            <label class=""><?php echo e(__('Status')); ?></label>

                            <select class="form-control" aria-label="Default select example" name="status">
                                <option value="Draft"
                                        <?php if(($notice->status ?? null) === 'Draft'): ?> selected <?php endif; ?>><?php echo e(__('Draft')); ?></option>
                                <option value="Published"
                                        <?php if(($notice->status ?? null) === 'Published'): ?> selected <?php endif; ?>><?php echo e(__('Published')); ?></option>

                            </select>
                        </div>

                        <label class="mt-4 text-sm mb-2"><?php echo e(__('Write Notice')); ?></label>


                        <div class="form-group">
                            <textarea class="form-control" rows="10" id="description" name="notes"><?php if(!empty($notice)): ?><?php echo e($notice->notes); ?><?php endif; ?>
                            </textarea>
                        </div>
                        <?php echo csrf_field(); ?>
                        <?php if($notice): ?>
                            <input type="hidden" name="id" value="<?php echo e($notice->id); ?>">
                        <?php endif; ?>

                        <div class="d-flex  mt-2 ">

                            <button type="submit" name="button" class="btn btn-info m-0 ">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </div>
                </div>

            </form>

        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        (function(){
            "use strict";
            tinymce.init({
                selector: '#description',
                plugins: 'lists,table',
                toolbar:'styleselect | forecolor | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image | code | undo redo|numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
                menubar: false,
            });


        })();
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/notice/new.blade.php ENDPATH**/ ?>