<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <?php echo e(__('Configure payment gateway')); ?>

        </div>

        <div class="card-body pt-0">

            <form action="/configure-gateway" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php switch($api_name):

                    case ('paypal'): ?>

                        <h5 class="mb-3"><?php echo e(__('PayPal')); ?></h5>

                        <div class="form-group">
                            <label for="Paypal Email/Paypal Client ID"><?php echo e(__('Paypal Email/Paypal Client ID')); ?></label>
                            <input type="email" name="username" class="form-control" id="exampleFormControlInput1">
                        </div>

                        <?php break; ?>


                    <?php case ('stripe'): ?>

                    <h5 class="mb-3"><?php echo e(__('Stripe')); ?></h5>

                        <div class="form-group">
                            <label for="Public Key"><?php echo e(__('Public Key')); ?></label>
                            <input type="text" name="public_key" <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->public_key); ?>"<?php endif; ?> class="form-control" id="public_key">
                        </div>

                        <div class="form-group">
                            <label for="Private Key"><?php echo e(__('Private Key')); ?></label>
                            <input type="text" name="private_key" <?php if(!empty($gateway)): ?> value="<?php echo e($gateway->private_key); ?>"<?php endif; ?> class="form-control" id="private-key">
                        </div>

                        <?php break; ?>


                    <?php endswitch; ?>



                <?php echo csrf_field(); ?>

                    <?php if($gateway): ?>
                        <input type="hidden" name="id" value="<?php echo e($gateway->id); ?>">
                    <?php endif; ?>


                <button type="submit" class="btn btn-success"><?php echo e(__('Save')); ?></button>


            </form>

        </div>





    </div>



<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/super-admin/configure-payment-gateway.blade.php ENDPATH**/ ?>